<?php $__env->startSection('title', __('lang.edit_limit')); ?>

<?php $__env->startSection('css'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb-title'); ?>
<h3><?php echo app('translator')->get('lang.edit_limit'); ?></h3>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb-items'); ?>
<li class="breadcrumb-item"><?php echo app('translator')->get('lang.Users'); ?></li>
<li class="breadcrumb-item"><a href="<?php echo e(route('admin.userCategoryLimits.index', $user->id)); ?>"><?php echo app('translator')->get('lang.user_category_limits'); ?></a></li>
<li class="breadcrumb-item active"><?php echo app('translator')->get('lang.edit_limit'); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-sm-12">
            <div class="card">
                <div class="card-header pb-0">
                    <h5><?php echo app('translator')->get('lang.edit_limit'); ?>: <?php echo e($user->name); ?> - <?php echo e($category->name ?? $category->name_en); ?></h5>
                </div>
                <div class="card-body">
                    <form class="needs-validation" method="POST" action="<?php echo e(route('admin.userCategoryLimits.update', [$user->id, $category->id])); ?>" novalidate>
                        <?php echo csrf_field(); ?>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label"><?php echo app('translator')->get('lang.Client'); ?></label>
                                <input type="text" class="form-control" value="<?php echo e($user->name); ?>" disabled>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label"><?php echo app('translator')->get('lang.Category'); ?></label>
                                <input type="text" class="form-control" value="<?php echo e($category->name ?? $category->name_en); ?>" disabled>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label"><?php echo app('translator')->get('lang.default_limit'); ?></label>
                                <input type="text" class="form-control" value="<?php echo e($category->free_ads_limit); ?>" disabled>
                                <small class="text-muted"><?php echo app('translator')->get('lang.free_ads_limit_hint'); ?></small>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label" for="free_ads_limit"><?php echo app('translator')->get('lang.custom_limit'); ?> <span class="text-danger">*</span></label>
                                <input type="number" class="form-control <?php $__errorArgs = ['free_ads_limit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    name="free_ads_limit" id="free_ads_limit"
                                    value="<?php echo e(old('free_ads_limit', $userLimit->free_ads_limit ?? $category->free_ads_limit)); ?>"
                                    min="0" required>
                                <?php $__errorArgs = ['free_ads_limit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label" for="used_ads_count"><?php echo app('translator')->get('lang.used_ads'); ?></label>
                                <input type="number" class="form-control <?php $__errorArgs = ['used_ads_count'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    name="used_ads_count" id="used_ads_count"
                                    value="<?php echo e(old('used_ads_count', $userLimit->used_ads_count ?? 0)); ?>"
                                    min="0">
                                <?php $__errorArgs = ['used_ads_count'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12">
                                <button class="btn btn-primary" type="submit"><?php echo app('translator')->get('lang.save'); ?></button>
                                <a href="<?php echo e(route('admin.userCategoryLimits.index', $user->id)); ?>" class="btn btn-secondary"><?php echo app('translator')->get('lang.cancel'); ?></a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script src="<?php echo e(asset('assets/js/form-validation-custom.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/wikala/public_html/wikala/resources/views/admin/users/edit_category_limit.blade.php ENDPATH**/ ?>