<?php $__env->startSection('title', __('lang.user_category_limits')); ?>

<?php $__env->startSection('css'); ?>
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/datatables.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb-title'); ?>
<h3><?php echo app('translator')->get('lang.user_category_limits'); ?>: <?php echo e($user->name); ?></h3>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb-items'); ?>
<li class="breadcrumb-item"><?php echo app('translator')->get('lang.Users'); ?></li>
<li class="breadcrumb-item active"><?php echo app('translator')->get('lang.user_category_limits'); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-sm-12">
            <div class="card">
                <div class="card-header pb-0">
                    <h5><?php echo app('translator')->get('lang.user_category_limits'); ?></h5>
                    <span><?php echo app('translator')->get('lang.free_ads_limit_hint'); ?></span>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="display" id="basic-1">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th><?php echo app('translator')->get('lang.Category'); ?></th>
                                    <th><?php echo app('translator')->get('lang.Status'); ?></th>
                                    <th><?php echo app('translator')->get('lang.default_limit'); ?></th>
                                    <th><?php echo app('translator')->get('lang.custom_limit'); ?></th>
                                    <th><?php echo app('translator')->get('lang.used_ads'); ?></th>
                                    <th><?php echo app('translator')->get('lang.remaining_ads'); ?></th>
                                    <th><?php echo app('translator')->get('lang.actions'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($loop->iteration); ?></td>
                                    <td><?php echo e($category['category_name']); ?></td>
                                    <td>
                                        <?php if($category['is_free']): ?>
                                        <span class="badge bg-success"><?php echo app('translator')->get('lang.free'); ?></span>
                                        <?php else: ?>
                                        <span class="badge bg-warning"><?php echo app('translator')->get('lang.not_free'); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($category['default_limit']); ?></td>
                                    <td>
                                        <?php if($category['has_custom_limit']): ?>
                                        <span class="badge bg-primary"><?php echo e($category['user_limit']); ?></span>
                                        <?php else: ?>
                                        <span class="text-muted">-</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($category['used_ads_count']); ?></td>
                                    <td>
                                        <?php
                                        $limit = $category['has_custom_limit'] ? $category['user_limit'] : $category['default_limit'];
                                        $remaining = max(0, $limit - $category['used_ads_count']);
                                        ?>
                                        <span class="<?php echo e($remaining > 0 ? 'text-success' : 'text-danger'); ?>"><?php echo e($remaining); ?></span>
                                    </td>
                                    <td>
                                        <a href="<?php echo e(route('admin.userCategoryLimits.edit', [$user->id, $category['category_id']])); ?>" class="btn btn-primary btn-sm">
                                            <i class="fa fa-edit"></i> <?php echo app('translator')->get('lang.edit_limit'); ?>
                                        </a>
                                        <?php if($category['has_custom_limit']): ?>
                                        <form action="<?php echo e(route('admin.userCategoryLimits.destroy', [$user->id, $category['category_id']])); ?>" method="POST" class="d-inline">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-warning btn-sm" onclick="return confirm('<?php echo app('translator')->get('lang.are_you_sure_delete'); ?>')">
                                                <i class="fa fa-undo"></i> <?php echo app('translator')->get('lang.reset_to_default'); ?>
                                            </button>
                                        </form>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script src="<?php echo e(asset('assets/js/datatable/datatables/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/datatable/datatables/datatable.custom.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/wikala/public_html/wikala/resources/views/admin/users/category_limits.blade.php ENDPATH**/ ?>